
  /*
   *  Object %    : %
   *  State           :  %state%
   *  Creation date   :  Mon Nov 29 14:10:40 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SEC_BOOT_flash.c#1:csrc:4
   *  \author adams
   *  \remarks Copyright (C) 2005 by Discretix Technologies Ltd.
   *           All Rights reserved
   */



/************* Include Files ****************/

#include "DX_VOS_BaseTypes.h"
#include "discretix.h"
#include "SEC_BOOT_RSA.h"

/************************ Defines ******************************/

/************************ Enums ******************************/


/************************ Typedefs ******************************/


/************************ Global Data ******************************/

DxUint32_t Flash[0x20000 / sizeof(DxUint32_t)];
#ifndef NOR_TEST
DxUint32_t WorkRam[1536];
#endif
DxUint32_t N[RSA_MOD_SIZE_IN_BITS/32];

/************* Private function prototype ****************/


/************************ Public Functions ******************************/

#ifndef NOR_TEST

/**
 * @brief The Flash interface function - needed to be implemented by customer:
 *         
 * @param[in] DestAddr_ptr   -  The destination address in working memory.
 * @param[in] startFlashAddr -  the start address in the flash.
 * @param[in] sizeInWords    -  The size in words.
 */                              
void GetFlashData( DxUint32_t *DestAddr_ptr, 
                   DxUint32_t startFlashAddr, 
                   DxUint32_t sizeInWords )
{
   /* LOCAL DECLERATIONS */
         
   /* FUNCTION LOGIC */
   
   UTIL_MemCopy( (DxUint8_t*)DestAddr_ptr , 
                 (DxUint8_t*)&Flash[startFlashAddr/sizeof(DxUint32_t)] , 
                 sizeInWords * sizeof(DxUint32_t) );
   
   return; 
   
}/* END OF GetFlashData */                                           

#endif

/************* Include Files ****************/


/************************ Defines ******************************/


/************************ Enums ******************************/


/************************ Typedefs ******************************/


/************************ Global Data ******************************/


/************* Private function prototype ****************/


/************************ Public Functions ******************************/

